/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.block;

import java.util.Locale;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.shared.block.SlimeType;

public class SlimeVineBlock
extends VineBlock {
    public static final EnumProperty<VineStage> STAGE = EnumProperty.m_61587_((String)"stage", VineStage.class);
    private final SlimeType foliage;

    public SlimeVineBlock(BlockBehaviour.Properties properties, SlimeType foliage) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(STAGE, (Comparable)((Object)VineStage.START)));
        this.foliage = foliage;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{STAGE});
    }

    public void m_7455_(BlockState state, ServerLevel worldIn, BlockPos pos, Random random) {
        if (worldIn.f_46443_) {
            return;
        }
        if (SlimeVineBlock.hasNoHorizontalSides(state)) {
            BlockState newState = state;
            boolean onLeaves = worldIn.m_8055_(pos.m_7494_()).m_204336_(TinkerTags.Blocks.SLIMY_LEAVES);
            for (Direction side : Direction.Plane.HORIZONTAL) {
                if (!onLeaves && !SlimeVineBlock.m_57853_((BlockGetter)worldIn, (BlockPos)pos.m_142300_(side), (Direction)side) || random.nextInt(6) != 0) continue;
                newState = (BlockState)newState.m_61124_((Property)SlimeVineBlock.m_57883_((Direction)side), (Comparable)Boolean.valueOf(true));
            }
            if (newState != state) {
                worldIn.m_7731_(pos, newState, 3);
            }
        } else if (random.nextInt(4) == 0) {
            this.grow((LevelAccessor)worldIn, random, pos, state);
        }
    }

    public void grow(LevelAccessor worldIn, Random random, BlockPos pos, BlockState state) {
        if (SlimeVineBlock.hasNoHorizontalSides(state) || state.m_61143_(STAGE) == VineStage.END) {
            return;
        }
        BlockPos below = pos.m_7495_();
        if (worldIn.m_46859_(below)) {
            if (SlimeVineBlock.freeFloating(worldIn, pos, state)) {
                BlockState above;
                int i;
                VineStage stage = (VineStage)((Object)state.m_61143_(STAGE));
                for (i = 1; i < 3 && (above = worldIn.m_8055_(pos.m_6630_(i))).m_60713_((Block)this) && above.m_61143_(STAGE) == stage; ++i) {
                }
                if (i > 2 || random.nextInt(2) == 0) {
                    state = (BlockState)state.m_61122_(STAGE);
                }
            }
            worldIn.m_7731_(below, (BlockState)state.m_61124_((Property)f_57833_, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        return SlimeVineBlock.hasSides(this.updateConnections(state, (BlockGetter)worldIn, pos));
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.DOWN) {
            return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        }
        BlockState updated = this.updateConnections(stateIn, (BlockGetter)worldIn, currentPos);
        return !SlimeVineBlock.hasSides(updated) ? Blocks.f_50016_.m_49966_() : updated;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos;
        Level world = context.m_43725_();
        BlockState currState = world.m_8055_(pos = context.m_8083_());
        boolean isVine = currState.m_60713_((Block)this);
        BlockState vineState = isVine ? currState : this.m_49966_();
        for (Direction direction : context.m_6232_()) {
            if (direction == Direction.DOWN) continue;
            BooleanProperty prop = SlimeVineBlock.m_57883_((Direction)direction);
            if (isVine && ((Boolean)currState.m_61143_((Property)prop)).booleanValue() || !this.hasAttachment((BlockGetter)world, pos, direction)) continue;
            return (BlockState)vineState.m_61124_((Property)prop, (Comparable)Boolean.valueOf(true));
        }
        return isVine ? vineState : null;
    }

    private static boolean hasSides(BlockState state) {
        for (BooleanProperty booleanproperty : f_57838_.values()) {
            if (!((Boolean)state.m_61143_((Property)booleanproperty)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private static boolean hasNoHorizontalSides(BlockState state) {
        for (Direction side : Direction.Plane.HORIZONTAL) {
            if (!((Boolean)state.m_61143_((Property)SlimeVineBlock.m_57883_((Direction)side))).booleanValue()) continue;
            return false;
        }
        return true;
    }

    private static boolean freeFloating(LevelAccessor world, BlockPos pos, BlockState state) {
        for (Direction side : Direction.Plane.HORIZONTAL) {
            if (!((Boolean)state.m_61143_((Property)SlimeVineBlock.m_57883_((Direction)side))).booleanValue() || !SlimeVineBlock.m_57853_((BlockGetter)world, (BlockPos)pos.m_142300_(side), (Direction)side)) continue;
            return false;
        }
        return true;
    }

    private BlockState updateConnections(BlockState state, BlockGetter world, BlockPos pos) {
        BlockPos up = pos.m_7494_();
        if (((Boolean)state.m_61143_((Property)f_57833_)).booleanValue()) {
            state = (BlockState)state.m_61124_((Property)f_57833_, (Comparable)Boolean.valueOf(SlimeVineBlock.m_57853_((BlockGetter)world, (BlockPos)up, (Direction)Direction.UP)));
        }
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BooleanProperty prop = SlimeVineBlock.m_57883_((Direction)direction);
            if (!((Boolean)state.m_61143_((Property)prop)).booleanValue()) continue;
            state = (BlockState)state.m_61124_((Property)prop, (Comparable)Boolean.valueOf(this.hasAttachment(world, pos, direction)));
        }
        return state;
    }

    private boolean hasAttachment(BlockGetter world, BlockPos pos, Direction side) {
        if (side == Direction.DOWN) {
            return false;
        }
        BlockPos offset = pos.m_142300_(side);
        if (SlimeVineBlock.m_57853_((BlockGetter)world, (BlockPos)offset, (Direction)side)) {
            return true;
        }
        BlockState upState = world.m_8055_(pos.m_7494_());
        if (upState.m_204336_(TinkerTags.Blocks.SLIMY_LEAVES)) {
            return true;
        }
        return side != Direction.UP && upState.m_60713_((Block)this) && (Boolean)upState.m_61143_((Property)f_57838_.get(side)) != false && upState.m_61143_(STAGE) != VineStage.END;
    }

    public SlimeType getFoliage() {
        return this.foliage;
    }

    public static enum VineStage implements StringRepresentable
    {
        START,
        MIDDLE,
        END;


        public String m_7912_() {
            return this.toString().toLowerCase(Locale.US);
        }
    }
}

